package wang.app.gradebook;

/**
 * Database Connection
 */
import java.sql.*;
import java.sql.SQLException;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

public class DBConnection {

    public static Connection cnn = null;
    public static Statement stmt = null;
    public static CallableStatement cstmt;
    public static String hostName = "artemis";   // "artimas"
    public static String dbInstanceName = "trackDB";   // "trackDB"
    public static String dbUser = "Gradebook", // "Gradebook"
            passwd = null,
            url = "jdbc:oracle:thin:@" + hostName + ".cs.csub.edu:1521:" + dbInstanceName;
                           //url = "jdbc:oracle:thin:@delphi.cs.csub.edu:1521:dbs01";

    public static boolean isConnected() {
        if ( cnn == null ) return false;
        return true;
    }

    public static Connection getConnection() {
        try {
            if (cnn != null && cnn.isValid(3)) {
                return cnn;
            }
            DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
            cnn = DriverManager.getConnection(url, dbUser, passwd);
            cnn.setAutoCommit(true);
            return cnn;
        } catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ResultSet getResultSet(String sql) {
        try {
            if (cnn == null) {
                getConnection();
            }
            stmt = cnn.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_UPDATABLE);
            // stmt = cnn.createStatement( ); //ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_UPDATABLE);
            // System.out.printf("SQL statement at line 50: %s\n", sql);
            return stmt.executeQuery(sql);
        } catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getCourseID() {
        try {
            cstmt = cnn.prepareCall("{? = call getCourseID (?, ?, ?, ?)}");
            cstmt.registerOutParameter(1, java.sql.Types.INTEGER);
            cstmt.setInt(2, GBGlobals.year);
            cstmt.setString(3, GBGlobals.term.toUpperCase());
            cstmt.setString(4, GBGlobals.courseName.toUpperCase());
            cstmt.setInt(5, GBGlobals.section);
            cstmt.executeQuery();
            return cstmt.getInt(1);
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return -1;

    }

    public static String getAllGrades(int studID) {
        try {
            cstmt = cnn.prepareCall("{? = call getAllGrades (?)}");
            cstmt.registerOutParameter(1, java.sql.Types.VARCHAR);
            cstmt.setInt(2, studID);
            cstmt.executeQuery();
            return cstmt.getString(1);
        } catch (SQLException e) {
            return null;
        }
    }

    public static String getCourseTitle(int courseID) {
        try {
            cstmt = cnn.prepareCall("{? = call getCourseTitle (?)}");
            cstmt.registerOutParameter(1, java.sql.Types.VARCHAR);
            cstmt.setInt(2, courseID);
            cstmt.executeQuery();
            return cstmt.getString(1);
        } catch (SQLException e) {
            return null;
        }
    }

    public static boolean deleteStudentFromClass(int studentID, int courseID) {
        try {
            cstmt = cnn.prepareCall("{call DeleteStudentFromClass  (?, ?)}");
            cstmt.setInt(1, studentID);
            cstmt.setInt(2, courseID);
            cstmt.execute();
            cnn.commit();
            return true;
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean deleteStudent(int stuID, int instructorID) {  // remove a student from all classes 
        // who has been in and delete the student.
        try {
            cstmt = cnn.prepareCall("{call  deleteStudent(?, ?)}");
            cstmt.setInt(1, stuID);   // student ID
            cstmt.setInt(2, instructorID);   // instructor's ID
            cstmt.execute();
            cnn.commit();
            return true;
        } catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deleteClass(int CID, int IID) {  // delete a class. polic and roster with given CRN and instorctor ID
        try {
            cstmt = cnn.prepareCall("{call  deleteClass (?, ?)}");
            cstmt.setInt(1, CID);
            cstmt.setInt(2, IID);
            cstmt.execute();
            cnn.commit();
            return true;
        } catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean removeClassRoster(int CID) {  // remote all students out a class.
        try {
            cstmt = cnn.prepareCall("{call removeClassRoster (?)}");
            cstmt.setInt(1, CID);
            cstmt.execute();
            cnn.commit();
            return true;
        } catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean addNewClass(String[] fieldValues) { // Add a new class and its policy with defau;t values
        try {
            cstmt = cnn.prepareCall("{call AddClass  (?, ?, ?, ?, ?, ?)}");
            for (int i = 0; i < fieldValues.length; i++) {
                if (i >= 0 && i <= 2 || i == 5) {
                    cstmt.setInt(i + 1, Integer.parseInt(fieldValues[i]));
                } else {
                    cstmt.setString(i + 1, fieldValues[i].toUpperCase());
                }
            }
            cstmt.execute();
            int count = cstmt.getUpdateCount();
            if (count < 0) {
                return false;
            }
            cnn.commit();
            return true;
        } catch (SQLException e) {
            return false;
        }
    }

    public static boolean addNewStudent(String[] values) { // Add a new students with all info.
        // when a new roster is loaed, all students
        // who have not taken class, will be added in.
        try {
            cstmt = cnn.prepareCall("{call AddStudent  (?, ?, ?, ?, ?, ?)}");
            for (int i = 0; i < values.length; i++) {
                if (i == 0 || i == values.length - 1) {
                    cstmt.setInt(i + 1, Integer.parseInt(values[i]));
                } else {
                    cstmt.setString(i + 1, values[i]);
                }
            }
            cstmt.execute();
            // cnn.commit();
            return true;
        } catch (SQLException e) {
            return false;
        }
    }

    public static boolean addStudentToClass(int studentID, int courseID) { // Add a existing student to class.
        //System.out.printf("Add student %d to class %d\n", studentID, courseID);
        try {
            cstmt = cnn.prepareCall("{call AddStudentToClass  (?, ?)}");
            cstmt.setInt(1, studentID);
            cstmt.setInt(2, courseID);
            cstmt.execute();
            // cnn.commit();
            return true;
        } catch (SQLException e) {
            //System.out.printf("%d is added to %d uncessfully.\n", studentID, courseID);
            return false;
        }
    }

    public static boolean calTotal(int cid) { // Based on curent grades for assignments, midterms and final
        // calculate the up today's total (percentage.
        try {
            cstmt = cnn.prepareCall("{call calTotal (?)}");
            cstmt.setInt(1, cid);
            cstmt.execute();
            return true;
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    /* The following functions: getAllTableNames, resultSetToVector( res, vec ), resultSetToVector(res, vec1, vec2)
     isAt( string, vector), and orderTableByRef( ) provide a set of all tables order by the foregin key
     ky referential constaints. The tables without foreign keys have the highest priorities, and tables with
     foregin keys must have lower priorities. The tables with higher priorities will exported and imported before
     the tables with lower priorities.
    
     The algorithm is found and implemented when I was on airplane from US to China, maybe in 2012.
     The motivation of this algorithm the need of remove all tables of all students at the end of the year.
     Deleting handruds of tables is not easy due the referential constraints. The alogirithm is very helfull
     for that task. New usage is to export and import the data.
     */
    public static Vector<String> getAllTableNames() {
        ResultSet res = getResultSet("SELECT tname FROM TAB WHERE TABTYPE = 'TABLE'");
        Vector<String> vAllTables = new Vector<String>(50), // All table names in the schema.   
                vPKTables = new Vector<String>(50), // vPKTables(i) table's primary key if referenced by vFKTables
                vFKTables = new Vector<String>(50);   // vFKTables(i) reference to vPKTables(i).

        resultSetToVector(res, vAllTables);
        Collections.sort(vAllTables);

        String pk_fk_table = "SELECT pk.table_name pk_table, fk.table_name fk_table "
                + " FROM   user_constraints fk, user_constraints pk "
                + " WHERE  fk.r_constraint_name = pk.constraint_name"
                + " ORDER  BY fk.table_name, pk.table_name ";
        res = getResultSet(pk_fk_table);

        resultSetToVector(res, vPKTables, vFKTables);

        Vector<String> vResult = new Vector<String>(vAllTables.size() + 1);
        orderTableNamesByRefConstraints(vAllTables, vPKTables, vFKTables, vResult);
        return vResult;

    }

    public static int getRecordCountsOfAllTables() {
        try {
            cstmt = cnn.prepareCall("{ call ? := getRecordCount( ) }");
            cstmt.registerOutParameter(1, Types.INTEGER);
            cstmt.execute();
            return cstmt.getInt(1);
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public static void resultSetToVector(ResultSet res, Vector<String> v) {
        try {
            while (res.next()) {
                v.add(res.getString(1));
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void resultSetToVector(ResultSet res, Vector<String> v1, Vector<String> v2) {
        try {
            while (res.next()) {
                v1.add(res.getString(1));
                v2.add(res.getString(2));
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    static void orderTableNamesByRefConstraints(Vector<String> allTable, Vector<String> pkTable, Vector<String> fkTable, Vector<String> resultTable) {
        String name = null;
        int pkPos, fkPos;
        boolean progressMade = false;  // True if one or more tabls is added to resultTable
        while (allTable.size() > 0) {
            for (int i = 0; i < allTable.size(); i++) {
                name = allTable.get(i);
                fkPos = isAt(name, fkTable);
                pkPos = isAt(name, pkTable);
                if (fkPos < 0) {
                    resultTable.add(name);
                    allTable.remove(i);
                    progressMade = true;

                    // Remove all referential constraints in which name appeared as table referenced
                    // by other tables in their foreign key constraints.
                    while (pkPos >= 0) {
                        // move one referential constraint with PK table = name
                        pkTable.remove(pkPos);
                        fkTable.remove(pkPos);
                        // Find out whether the  same table appear in another ref. constraint.
                        // If it does, remove the ref. constraint again.
                        pkPos = isAt(name, pkTable);
                    }
                }
            }

            // If there is a recurisve referential constraint then the table cannot be added in.
            // The recursive ref. constraint is  caused by the first row in pkTable and fkTable,
            // Move the first referential constraint will proceed the process.
            if (!progressMade) {
                pkTable.remove(0);
                fkTable.remove(0);
            }
            progressMade = false;

        }
    }

    public static int isAt(String str, Vector<String> v) {
        if (str == null || v == null || v.size() < 1) {
            return -1;
        }
        for (int i = 0; i < v.size(); i++) {
            if (str.equals(v.get(i))) {
                return i;
            }
        }

        return -1;
    }

}
