/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package wang.app.gradebook;

import java.io.File;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.sql.ResultSet;
import java.io.PrintWriter;
import java.util.Locale;
import java.sql.ResultSet;
import java.lang.StringBuffer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

/**
 *
 * @author hwang
 */
public class GBUtil {

    static void loadYears(JComboBox<Integer> cbx) {
        cbx.removeAllItems();
        try {  // In Java resultset, the first row is numbered 0 and 
            // the first column is numbered as 1.
            ResultSet rs = DBConnection.getResultSet("Select * from VYears");
            while (rs.next()) {
                cbx.addItem(rs.getInt(1));
            }
            rs.close();
            if (cbx.getItemCount() > 0) {
                cbx.setSelectedIndex(0);
                GBGlobals.year = Integer.parseInt(cbx.getSelectedItem().toString());
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @SuppressWarnings("unchecked")

    static void loadCourses(JComboBox<String> cbx) {
        cbx.removeAllItems();
        try {
            String sql = "SELECT cName FROM classes WHERE year = " + GBGlobals.year + " AND Quarter = '" + GBGlobals.term + "'";
            // System.out.printf("sql = %s\n", sql);
            //if ( true ) return;
            ResultSet rs = DBConnection.getResultSet(sql);
            while (rs.next()) {
                cbx.addItem(rs.getString(1));
            }
            rs.close();
            if (cbx.getItemCount() > 0) {
                cbx.setSelectedIndex(0);
                GBGlobals.courseName = cbx.getSelectedItem().toString().toUpperCase();
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    // Term combobox contains Fall-0, Winter-1, Spring-2, Summer-3.
    static void setTerm(JComboBox<String> cmbTerms) {
        //int year = cal.get(cal.YEAR);
        int month = GBGlobals.cal.get(GBGlobals.cal.MONTH) + 1; //zero-based

        switch (month) {
            case 8:
            case 9:
            case 10:
            case 11:
            case 12:  // Fall term
                cmbTerms.setSelectedIndex(0);
                break;
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:     // winter term
                cmbTerms.setSelectedIndex(1);
                break;
            case 6:
            case 7:                             // Summber term
                cmbTerms.setSelectedIndex(3);
                break;
            default:
                cmbTerms.setSelectedIndex(2);     //Spring - term no month left for spring
        }
        GBGlobals.term = cmbTerms.getSelectedItem().toString().toUpperCase();
    }

    static String saveClassGradeToFile(JTextArea ta) {
        String fileName = GBGlobals.gradebookData + "onlineData/"
                + "Class" + GBGlobals.courseName.replaceAll(" ", "") + GBGlobals.section + "sco.dat";
        PrintWriter fout = null;

        StringBuffer buf1 = new StringBuffer(1000);
        StringBuffer buf2 = new StringBuffer(20000);
        float max[] = new float[GBGlobals.numHWK + 4];   // number of homework plus midter1, midterm2 and final needs max, mix and average.
        float min[] = new float[GBGlobals.numHWK + 4];
        float sum[] = new float[GBGlobals.numHWK + 4];
        int rankHigh = -1, rankLow = -2;
        float totalHigh = 0f, totalLow = 0f;
        String gradeHigh = null, gradeLow = null;

        for (int i = 0; i < min.length; i++) {
            min[i] = 100f;
        }
        ResultSet rs = DBConnection.getResultSet(buildGradePosterSQL());
        try {
            fout = new PrintWriter(fileName);
            int rowCount = -1, colCount = GBGlobals.numHWK + 8;
            float score;

            while (rs.next()) {
                rowCount++;
                if (rowCount == 0) {  // save highest ranking (the smallest ranking number), total (update percentage and letter grade
                    rankHigh = rs.getInt("Ranking");  // Highest ranking of the class 
                    totalHigh = rs.getFloat("Total");   // Highest up todate PCT
                    gradeHigh = rs.getString("Grade");  // Highest letter grades
                }
                if (rowCount == GBGlobals.classSize - 1) {
                    rankLow = rs.getInt("Ranking");  // The loswest ranking
                    totalLow = rs.getFloat("Total");    // up to date PCT
                    gradeLow = rs.getString("Grade");
                }

                // Write the one row info. for one student information out to file.
                // Column 1 : Student ID
                for (int col = 1; col <= colCount; col++) {
                    if (col == 1) {//print last 4 digits ID.
                        buf2.append(String.format("\n%04d ", rs.getInt(col) % 10000));
                        continue;
                    }
                    // Column 2 to GBGlobals.numHWK are assignments grades.
                    // Column GBGlobals.numHWK + 1 ... GBGlobals.numHWK + 5 are mid1, mid2, final, UTD PCT.
                    // Columns 2 to GBGlobals.numHWK + 5 are float values.
                    if (col >= 2 && col <= GBGlobals.numHWK + 5) { // change the max or mix value of homework and test.
                        score = rs.getFloat(col);
                        max[col - 2] = score > max[col - 2] ? score : max[col - 2];
                        min[col - 2] = score < min[col - 2] ? score : min[col - 2];
                        sum[col - 2] += score;
                        if (col == GBGlobals.numHWK + 5) {
                            buf2.append(String.format("%7.2f ", rs.getFloat(col)));
                        } else {
                            buf2.append(String.format("%7.1f ", rs.getFloat(col)));
                        }
                    }

                    if (col == GBGlobals.numHWK + 6) // Column Ranking int type.
                    {
                        buf2.append(String.format("%7d ", rs.getInt(col)));
                    } else if (col == GBGlobals.numHWK + 7) // Letter gade column
                    {
                        buf2.append(String.format("%7s\n", rs.getString(col)));
                    } else if (col == GBGlobals.numHWK + 8) { // print out commments on its onwn line.
                        String str = rs.getString(col);
                        str = str == null ? "" : str.replaceAll("\n", " ");
                        buf2.append(String.format("Comments: %s\n", str));
                    }
                }
            }
            printHeader(buf1);
            buf1.append(String.format("\nMid1: Hi-Low-Avg( %1.1f - %1.1f - %1.2f); Mid2: Hi-Low-Avg (%1.1f - %1.1f - %1.2f)  Final: Hi-Low-Avg(%1.1f - %1.1f - %1.2f)\n",
                    max[GBGlobals.numHWK], min[GBGlobals.numHWK], sum[GBGlobals.numHWK] / GBGlobals.classSize, max[GBGlobals.numHWK + 1], min[GBGlobals.numHWK + 1], sum[GBGlobals.numHWK + 1] / GBGlobals.classSize,
                    max[GBGlobals.numHWK + 2], min[GBGlobals.numHWK + 2], sum[GBGlobals.numHWK + 2] / GBGlobals.classSize));
            buf1.append("\nAssignment/Exams:");
            for (int i = 1; i <= GBGlobals.numHWK; i++) {
                buf1.append(String.format("%9d", i));
            }
            buf1.append(String.format("%7s %7s %7s %7s %7s %7s\n", "Mid1", "Mid2", "Final", "UTD%", "Rank", "Grade"));
            buf1.append(String.format("%s   ", "Max:Min"));
            for (int i = 0; i < GBGlobals.numHWK + 3; i++) {
                buf1.append(String.format(" %5.1f:%1.1f", max[i], min[i]));
            }
            buf1.append(String.format(" %1.2f:%1.2f   %d:%d    %2s:%s\n", totalHigh, totalLow, rankHigh, rankLow, gradeHigh, gradeLow));
            fout.printf("%s", buf1.toString());
            fout.printf("%s", buf2.toString());
            fout.flush();
            fout.close();
            ta.setText(buf1.toString());
            ta.append(buf2.toString());
            //System.out.printf("%s", buf1.toString());
            //System.out.printf("%s", buf2.toString());
            return fileName;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static void printHeader(StringBuffer buf) {
        buf.append(String.format("Grade Report for %s-%d %s, %d\n", GBGlobals.courseName, GBGlobals.section, GBGlobals.term, GBGlobals.year));
        buf.append(String.format("Enrollment: %d\n", GBGlobals.classSize));
        buf.append(String.format("Date/Time Report Generated: %s\n", GBGlobals.cal.getTime().toString()));
        buf.append("Appllication: Gradebook System (CGI in C++, Oracle Database, Visual Studion/C# and NetBeans/Java\n");
        buf.append("Author: H. Wang, Designed and Impleted Dec. 1996. The Java Interface started March 2016 (661-654-2357)\n");
    }

    static String getClassInfo() {
        GBGlobals.classInfo = String.format("%s/%s/%d/Sec-%d ",
                GBGlobals.courseName, GBGlobals.term, GBGlobals.year, GBGlobals.section);
        return GBGlobals.classInfo;
    }

    static String getEnrollmentInfo() {
        GBGlobals.enrollmentInfo = String.format("CRN-[%d] %d Enrolled", GBGlobals.CID, GBGlobals.classSize);
        return GBGlobals.enrollmentInfo;
    }

    static String buildGradePosterSQL() {
        String sql = "SELECT SID";
        for (int i = 1; i <= GBGlobals.numHWK; i++) {
            sql += ", HW" + i;
        }
        sql += ", MIDTERM1, MIDTERM2, Final, Total, Ranking, Grade, Comments FROM VGrades WHERE CID = " + GBGlobals.CID
                + "Order By Total DESC";
        //System.out.printf("Build ClassGrade String: %s\n", sql);
        return sql;
    }

    static String getFileName(String dir) {
        JFileChooser chooser = new JFileChooser(dir);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Text File", "dat", "txt");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            //System.out.println("getPath() : " + chooser.getSelectedFile().getName());
            //System.out.println("getAbsolutePath() : " + chooser.getSelectedFile().getAbsolutePath());
            //try { System.out.println("getCanonicalPath() : " + chooser.getSelectedFile().getCanonicalPath());} catch (Exception e) {}
            return chooser.getSelectedFile().getAbsolutePath(); // .getName() - File name only;
        }
        return null;
    }
    static void   printFileOnTextArea( String fileName, JTextArea ta) {
        String line = null;
        BufferedReader in  = null;
        int cnt = 0;
        ta.setText("");
        try {
            in = new BufferedReader ( new FileReader( fileName ));
            while ( (line = in.readLine())  != null) {
                ta.append(line + "\n");
                cnt++;
            }
        } catch (Exception e) { }
        try { in.close(); } catch (Exception e2) {}
        ta.append(String.format("\nFile [%s] contains %d lines.\n", 
                fileName.substring(fileName.lastIndexOf("/") + 1), cnt));
    }
}
   

