package wang.app.gradebook;

import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import java.sql.*;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import javax.swing.SwingConstants;
import javax.swing.ListSelectionModel;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import javax.swing.JTextArea;
import javax.swing.RowFilter;
import javax.swing.JPasswordField;
import javax.swing.DefaultComboBoxModel;
import java.text.SimpleDateFormat;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.view.JasperViewer;
import java.io.File;
import javax.naming.InitialContext;
import javax.naming.Context;
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author hwang
 */
@SuppressWarnings("unchecked")
public final class GradebookJFrame extends javax.swing.JFrame {

    PasswordPane pwd = null;
    int tried = 0;

    public GradebookJFrame() {
        
        DBConnection.passwd ="HSYSsanyuan342";
        DBConnection.getConnection();
        while (!DBConnection.isConnected()) {
            tried++;
            if (tried >= 3)  System.exit(-1);
            pwd = new PasswordPane(null);
            DBConnection.passwd = pwd.getPassword();
            if ( DBConnection.passwd == null) System.exit(0);
            if ( DBConnection.passwd.trim().length() < 6) continue;
            
            DBConnection.getConnection();
        }
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        initComponents();
        addRadionButtonToGroup();
        tfPolicy = new JTextField[]{numHWK, maxHWK, pctHWK, HWKDrops, maxMidterm1, PCTMidterm1, maxMidterm2, PCTMidterm2, maxFinal, PCTFinal};
        loadAndSelectComboboxes();
        addListenerForCommentField();
        addListenerForTableSelectionChange();

        addDocumentListenerForStudentsFilter();
    }

    boolean areCourseInfoSelected() {
        return cmbYears.getItemCount() > 0 && cmbTerms.getItemCount() > 0
                && cmbCourses.getItemCount() > 0 && cmbSections.getItemCount() > 0;
    }

    void loadMajors() {
        majorsTMD = new SimpleRSModel(sqlMajors);
        tblMajors.setModel(majorsTMD);
        tblMajors.setRowSorter(new TableRowSorter(majorsTMD));
        GBGlobals.majorsCount = majorsTMD.getRowCount();
        ((TitledBorder) pnMajors.getBorder()).setTitle("Major List " + GBGlobals.majorsCount);
        tblMajors.removeColumn(tblMajors.getColumnModel().getColumn(2));
    }

    // Status could be 'Y', 'N' or '%' for all
    static char choice = 'Y';

    void loadStudents() {
        loadStudents(choice);
    }

    void loadStudents(char status) {
        choice = status;
        studentsTMD = new SimpleRSModel(sqlStudents + " '" + status + "'");
        tblStudents.setModel(studentsTMD);
        studentsSorter = new TableRowSorter(studentsTMD);
        tblStudents.setRowSorter(studentsSorter);
        GBGlobals.studentsCount = studentsTMD.getRowCount();
        if (title == null) {
            title = (TitledBorder) pnStudents.getBorder();
        }
        String sts = status == '%' ? "All" : status == 'Y' ? "Active" : "Inactive";
        title.setTitle(sts + " Student List " + GBGlobals.studentsCount);
        tblStudents.removeColumn(tblStudents.getColumnModel().getColumn(3));
        tblStudents.removeColumn(tblStudents.getColumnModel().getColumn(4));
        tblStudents.removeColumn(tblStudents.getColumnModel().getColumn(0));
        pnStudents.repaint();
    }

    void loadClassGrade() {
        GBGlobals.loadingTime = true;
        cnn = DBConnection.getConnection();
        poicyResultSetTextField = new ResultSetTextFields(DBConnection.getResultSet(sqlPolicy + GBGlobals.CID), tfPolicy);
        // GBGlobals.numHWK = Integer.parseInt(numHWK.getText());
        sqlClassGrade = buildGradeSQL();
        classGradeTMD = new ResultSetTableModel(sqlClassGrade, editableItems);
        GBGlobals.classSize = classGradeTMD.recordCount;
        sorter = new TableRowSorter(classGradeTMD);
        tbl.setModel(classGradeTMD);
        tbl.removeColumn(tbl.getColumnModel().getColumn(0));
        tbl.removeColumn(tbl.getColumnModel().getColumn(0));
        tbl.removeColumn(tbl.getColumnModel().getColumn(tbl.getColumnModel().getColumnCount() - 1));
        tbl.setRowSorter(sorter);
        tbl.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        GBGlobals.loadingTime = false;
    }

    void addListenerForCommentField() {

        comments.addKeyListener(new KeyListener() {
            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                int kc = e.getKeyCode();
                if (kc == KeyEvent.VK_ALT || kc == KeyEvent.VK_CONTROL) {
                    saveComments();
                    return;
                }
                if (comments.getForeground() != commentsChangedColor) {
                    comments.setForeground(commentsChangedColor);
                }
                // classGradeTMD.setValueAt(comments.getText(), mdlRow, classGradeTMD.columnCount - 1);
            }
        });

    }

    void addDocumentListenerForStudentsFilter() {
        tfStudentsFilter.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                createAndSetNewFilter(tfStudentsFilter.getText().trim());
            }

            public void insertUpdate(DocumentEvent e) {
                createAndSetNewFilter(tfStudentsFilter.getText().trim());
            }

            public void removeUpdate(DocumentEvent e) {
                createAndSetNewFilter(tfStudentsFilter.getText().trim());
            }
        });
    }

    void saveComments() {
        classGradeTMD.setValueAt(comments.getText(), mdlRow, classGradeTMD.columnCount - 1);
        comments.setForeground(Color.BLACK);
    }

    void loadAndSelectComboboxes() {
        GBUtil.loadYears(cmbYears);     // Load years combobox from database
        GBUtil.setTerm(cmbTerms);
        GBGlobals.section = Integer.parseInt(cmbSections.getSelectedItem().toString());
        GBUtil.loadCourses(cmbCourses);
    }

    void addListenerForTableSelectionChange() {
        tbl.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel) e.getSource();
                if (lsm.isSelectionEmpty()) {
                } else {
                    tableRow = tbl.getSelectedRow();
                    mdlRow = tbl.convertRowIndexToModel(tableRow);
                    // table row's last column contains the comments on strudent grades.
                    Object obj = classGradeTMD.getValueAt(mdlRow, classGradeTMD.columnCount - 1);
                    comments.setText(obj == null ? "" : obj.toString());
                }
            }
        });
        tblMajors.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel) e.getSource();
                if (lsm.isSelectionEmpty()) {
                } else {
                    tableRow = tblMajors.getSelectedRow();
                    mdlRowForMajors = tblMajors.convertRowIndexToModel(tableRow);
                    GBGlobals.majorInfo
                            = majorsTMD.getValueAt(mdlRowForMajors, 1) + "["
                            + majorsTMD.getValueAt(mdlRowForMajors, 0) + "]";

                    // System.out.printf("Current Major selected: %s\n", GBGlobals.majorInfo);
                }
            }
        });
        tblStudents.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel) e.getSource();
                if (lsm.isSelectionEmpty()) {
                } else {
                    tableRow = tblStudents.getSelectedRow();
                    mdlRowForStudents = tblStudents.convertRowIndexToModel(tableRow);
                    GBGlobals.studentInfo = studentsTMD.getValueAt(mdlRowForStudents, 1) + ", "
                            + studentsTMD.getValueAt(mdlRowForStudents, 2);

                    //System.out.printf("Current Major selected: %s\n", GBGlobals.studentInfo);
                }
            }
        });
    }

    String buildGradeSQL() {
        GBGlobals.numHWK = Integer.parseInt(numHWK.getText());
        String sql = "SELECT CID, SID, LastName Last, FirstName First, Ranking \"Rank\", Total \"UTD %\", Grade";
        for (int i = 1; i <= GBGlobals.numHWK; i++) {
            sql += ", HW" + i;
        }
        sql += ", MIDTERM1 \"MID1\", MIDTERM2 \"MID2\", Final,  Comments FROM VGrades WHERE CID = " + GBGlobals.CID
                + " ORDER BY First, Last";
        //System.out.printf("Build ClassGrade String: %s\n", sql);
        reloadEditableItemsComboBox();
        return sql;
    }

    void reloadEditableItemsComboBox() {
        editableItems.removeAllItems();
        editableItems.addItem("Grade");
        for (int i = 1; i <= GBGlobals.numHWK; i++) {
            editableItems.addItem("HW" + i);
        }
        editableItems.addItem("Mid 1");
        editableItems.addItem("Mid 2");
        editableItems.addItem("Final");
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        bnGrpForRadion = new javax.swing.ButtonGroup();
        tabbedPanelswith4 = new javax.swing.JTabbedPane();
        pnCLassGrade = new javax.swing.JPanel();
        pnPolicy = new javax.swing.JPanel();
        cmbYears = new javax.swing.JComboBox();
        cmbTerms = new javax.swing.JComboBox();
        cmbCourses = new javax.swing.JComboBox();
        cmbSections = new javax.swing.JComboBox();
        jTextField1 = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        comments = new javax.swing.JTextArea();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        numHWK = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        maxHWK = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        pctHWK = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        HWKDrops = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        maxMidterm1 = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        PCTMidterm1 = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        maxMidterm2 = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        PCTMidterm2 = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        maxFinal = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        PCTFinal = new javax.swing.JTextField();
        editableItems = new javax.swing.JComboBox();
        jScrollPane2 = new javax.swing.JScrollPane();
        tbl = new javax.swing.JTable();
        jToolBar1 = new javax.swing.JToolBar();
        removeCurrentClass = new javax.swing.JButton();
        removeSelectedStudentFromClass = new javax.swing.JButton();
        removeRoster = new javax.swing.JButton();
        savePolicyUpdates = new javax.swing.JButton();
        calculeUptoDayTotol = new javax.swing.JButton();
        saveCurrentCLassToFile = new javax.swing.JButton();
        classReport = new javax.swing.JButton();
        addNewClass = new javax.swing.JButton();
        pnRosterLoader = new javax.swing.JPanel();
        rosterToolbar = new javax.swing.JToolBar();
        clearScreen = new javax.swing.JButton();
        loadRosterToDB = new javax.swing.JButton();
        jScrollPane6 = new javax.swing.JScrollPane();
        rosterSheet = new javax.swing.JTextArea();
        pnStudentsAndMajors = new javax.swing.JPanel();
        jToolBar2 = new javax.swing.JToolBar();
        addStudentToClass = new javax.swing.JButton();
        showAllGradesOfSelectedStudent = new javax.swing.JButton();
        deleteStudent = new javax.swing.JButton();
        rdoAll = new javax.swing.JRadioButton();
        rdoInactive = new javax.swing.JRadioButton();
        rdoActive = new javax.swing.JRadioButton();
        loadStudentsAndMajors = new javax.swing.JButton();
        tfStudentsFilter = new javax.swing.JTextField();
        pnMajors = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        tblMajors = new javax.swing.JTable();
        pnStudents = new javax.swing.JPanel();
        scPnStudents = new javax.swing.JScrollPane();
        tblStudents = new javax.swing.JTable();
        pnExportAndImport = new javax.swing.JPanel();
        tbExportAndExport = new javax.swing.JToolBar();
        clearTAExportAndExport = new javax.swing.JButton();
        fileOpen = new javax.swing.JButton();
        doImport = new javax.swing.JButton();
        doExport = new javax.swing.JButton();
        cbxTables = new javax.swing.JComboBox();
        loadAllTables = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        pBarExportAndImport = new javax.swing.JProgressBar();
        jScrollPane4 = new javax.swing.JScrollPane();
        taExportAndImport = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Gradebook - NetBean & Java");
        setFont(new java.awt.Font("Al Bayan", 1, 13)); // NOI18N
        setForeground(new java.awt.Color(102, 102, 102));
        setLocation(new java.awt.Point(200, 23));
        setSize(new java.awt.Dimension(850, 850));
        getContentPane().setLayout(null);

        tabbedPanelswith4.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        tabbedPanelswith4.setPreferredSize(new java.awt.Dimension(880, 1872));

        pnPolicy.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "     Year               Term                  Course            Sec.               Filter                                                           Grading Policy ", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Lucida Grande", 0, 12))); // NOI18N
        pnPolicy.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N

        cmbYears.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        cmbYears.setName("cmbYear"); // NOI18N
        cmbYears.setOpaque(true);
        cmbYears.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbYearsActionPerformed(evt);
            }
        });

        cmbTerms.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        cmbTerms.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Fall", "Winter", "Spring", "Summer" }));
        cmbTerms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbTermsActionPerformed(evt);
            }
        });

        cmbCourses.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        cmbCourses.setMaximumRowCount(10);
        cmbCourses.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbCoursesActionPerformed(evt);
            }
        });

        cmbSections.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        cmbSections.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "1", "2", "3", "4" }));
        cmbSections.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbSectionsActionPerformed(evt);
            }
        });

        jTextField1.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N

        jScrollPane1.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N

        comments.setColumns(20);
        comments.setFont(new java.awt.Font("Lucida Grande", 0, 12)); // NOI18N
        comments.setLineWrap(true);
        comments.setRows(4);
        comments.setToolTipText("Press ATL or Ctrl key to save comments to database.");
        jScrollPane1.setViewportView(comments);

        jLabel1.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        jLabel1.setText("No. of HMK");
        jLabel1.setToolTipText("");
        jLabel1.setHorizontalTextPosition(                                                                 SwingConstants.RIGHT                     );

        numHWK.setColumns(4);
        numHWK.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
        numHWK.setText("5");
        numHWK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                numHWKActionPerformed(evt);
            }
        });

        jLabel2.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        jLabel2.setText("Max HMK");

        maxHWK.setColumns(4);
        maxHWK.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
        maxHWK.setText("50");

        jLabel3.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        jLabel3.setText("HMK %");
        jLabel3.setToolTipText("");

        pctHWK.setColumns(4);
        pctHWK.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
        pctHWK.setText("40");

        jLabel4.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        jLabel4.setText("HMK Drops");
        jLabel4.setHorizontalTextPosition(                                                                 SwingConstants.RIGHT                     );

        HWKDrops.setColumns(4);
        HWKDrops.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
        HWKDrops.setText("0");

        jLabel5.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel5.setText("Max Mid1");
        jLabel5.setToolTipText("");

        maxMidterm1.setColumns(4);
        maxMidterm1.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
        maxMidterm1.setText("100");

        jLabel6.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        jLabel6.setText("Mid 1 %");

        PCTMidterm1.setColumns(4);
        PCTMidterm1.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
        PCTMidterm1.setText("30");
        PCTMidterm1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PCTMidterm1ActionPerformed(evt);
            }
        });

        jLabel7.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        jLabel7.setText("Max Mid2");
        jLabel7.setToolTipText("");
        jLabel7.setHorizontalTextPosition(                                                                 SwingConstants.RIGHT                     );

        maxMidterm2.setColumns(4);
        maxMidterm2.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
        maxMidterm2.setText("0");

        jLabel8.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        jLabel8.setText("Mid2 %");

        PCTMidterm2.setColumns(4);
        PCTMidterm2.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
        PCTMidterm2.setText("0");

        jLabel13.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        jLabel13.setText("Editable Col");

        jLabel9.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        jLabel9.setText("Max. Final");
        jLabel9.setHorizontalTextPosition(                                                                 SwingConstants.RIGHT                     );

        maxFinal.setColumns(4);
        maxFinal.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
        maxFinal.setText("100");

        jLabel10.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        jLabel10.setText("Final %");

        PCTFinal.setColumns(4);
        PCTFinal.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
        PCTFinal.setText("30");

        editableItems.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel9)
                    .addComponent(jLabel7, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(maxFinal, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 39, Short.MAX_VALUE)
                    .addComponent(numHWK, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(HWKDrops, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addComponent(maxMidterm2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 1, Short.MAX_VALUE))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(jLabel8)
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                                .addGap(0, 0, Short.MAX_VALUE)
                                .addComponent(jLabel10)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(PCTFinal)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(PCTMidterm2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(0, 0, Short.MAX_VALUE))))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel5))
                        .addGap(8, 8, 8)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(maxHWK, javax.swing.GroupLayout.DEFAULT_SIZE, 36, Short.MAX_VALUE)
                            .addComponent(maxMidterm1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(6, 6, 6)
                        .addComponent(jLabel13))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel6, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel3, javax.swing.GroupLayout.Alignment.TRAILING))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(pctHWK, javax.swing.GroupLayout.DEFAULT_SIZE, 37, Short.MAX_VALUE)
                            .addComponent(PCTMidterm1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)))
                    .addComponent(editableItems, javax.swing.GroupLayout.PREFERRED_SIZE, 85, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(33, 33, 33))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(jLabel2)
                            .addComponent(maxHWK, javax.swing.GroupLayout.DEFAULT_SIZE, 30, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(jLabel5)
                            .addComponent(maxMidterm1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel8)
                            .addComponent(PCTMidterm2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(41, 41, 41))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(9, 9, 9)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(jLabel1)
                            .addComponent(numHWK, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel3)
                            .addComponent(pctHWK))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(jLabel4)
                            .addComponent(HWKDrops, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(PCTMidterm1, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(5, 5, 5)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                .addComponent(jLabel7)
                                .addComponent(maxMidterm2))
                            .addComponent(jLabel13))
                        .addGap(4, 4, 4)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(jLabel9)
                            .addComponent(maxFinal, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel10)
                            .addComponent(PCTFinal, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(editableItems, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(8, 8, 8)))
                .addContainerGap())
        );

        javax.swing.GroupLayout pnPolicyLayout = new javax.swing.GroupLayout(pnPolicy);
        pnPolicy.setLayout(pnPolicyLayout);
        pnPolicyLayout.setHorizontalGroup(
            pnPolicyLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnPolicyLayout.createSequentialGroup()
                .addGroup(pnPolicyLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addGroup(pnPolicyLayout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(cmbYears, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(cmbTerms, javax.swing.GroupLayout.PREFERRED_SIZE, 85, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cmbCourses, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cmbSections, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(pnPolicyLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 451, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 324, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(12, Short.MAX_VALUE))
        );
        pnPolicyLayout.setVerticalGroup(
            pnPolicyLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnPolicyLayout.createSequentialGroup()
                .addGap(13, 13, 13)
                .addGroup(pnPolicyLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cmbSections, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cmbCourses, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cmbTerms, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cmbYears, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1)
                .addContainerGap())
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnPolicyLayout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        jScrollPane2.setFont(new java.awt.Font("Lucida Grande", 0, 12)); // NOI18N

        tbl.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane2.setViewportView(tbl);

        jToolBar1.setRollover(true);

        removeCurrentClass.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/rmClass.png"))); // NOI18N
        removeCurrentClass.setToolTipText("Delete current class");
        removeCurrentClass.setFocusable(false);
        removeCurrentClass.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        removeCurrentClass.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        removeCurrentClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeCurrentClassActionPerformed(evt);
            }
        });
        jToolBar1.add(removeCurrentClass);

        removeSelectedStudentFromClass.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/rm1FromClass.png"))); // NOI18N
        removeSelectedStudentFromClass.setToolTipText("Remove selected student from class.");
        removeSelectedStudentFromClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeSelectedStudentFromClassActionPerformed(evt);
            }
        });
        jToolBar1.add(removeSelectedStudentFromClass);

        removeRoster.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/rmRoster.png"))); // NOI18N
        removeRoster.setToolTipText("Remove current class roster");
        removeRoster.setFocusable(false);
        removeRoster.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        removeRoster.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        removeRoster.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeRosterActionPerformed(evt);
            }
        });
        jToolBar1.add(removeRoster);

        savePolicyUpdates.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/save.png"))); // NOI18N
        savePolicyUpdates.setToolTipText("Save changes in policy");
        savePolicyUpdates.setFocusable(false);
        savePolicyUpdates.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        savePolicyUpdates.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        savePolicyUpdates.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                savePolicyUpdatesActionPerformed(evt);
            }
        });

        calculeUptoDayTotol.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
        calculeUptoDayTotol.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/calcGrades.png"))); // NOI18N
        calculeUptoDayTotol.setToolTipText("Calculate up today 's percentage achieved.");
        calculeUptoDayTotol.setFocusable(false);
        calculeUptoDayTotol.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        calculeUptoDayTotol.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        calculeUptoDayTotol.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                calculeUptoDayTotolActionPerformed(evt);
            }
        });

        saveCurrentCLassToFile.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/saveFile.png"))); // NOI18N
        saveCurrentCLassToFile.setToolTipText("Save class grade to file.");
        saveCurrentCLassToFile.setFocusable(false);
        saveCurrentCLassToFile.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        saveCurrentCLassToFile.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        saveCurrentCLassToFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveCurrentCLassToFileActionPerformed(evt);
            }
        });

        classReport.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/classGrades.png"))); // NOI18N
        classReport.setToolTipText("Generate a class grade report.");
        classReport.setFocusable(false);
        classReport.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        classReport.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        classReport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                classReportActionPerformed(evt);
            }
        });

        addNewClass.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/addClass.png"))); // NOI18N
        addNewClass.setToolTipText("Add a new class.");
        addNewClass.setFocusable(false);
        addNewClass.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        addNewClass.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        addNewClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addNewClassActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnCLassGradeLayout = new javax.swing.GroupLayout(pnCLassGrade);
        pnCLassGrade.setLayout(pnCLassGradeLayout);
        pnCLassGradeLayout.setHorizontalGroup(
            pnCLassGradeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnCLassGradeLayout.createSequentialGroup()
                .addGap(75, 75, 75)
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(addNewClass)
                .addGap(37, 37, 37)
                .addComponent(saveCurrentCLassToFile)
                .addGap(36, 36, 36)
                .addComponent(calculeUptoDayTotol)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(classReport)
                .addGap(102, 102, 102)
                .addComponent(savePolicyUpdates)
                .addGap(174, 174, 174))
            .addGroup(pnCLassGradeLayout.createSequentialGroup()
                .addGroup(pnCLassGradeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jScrollPane2)
                    .addComponent(pnPolicy, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(0, 42, Short.MAX_VALUE))
        );
        pnCLassGradeLayout.setVerticalGroup(
            pnCLassGradeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnCLassGradeLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnCLassGradeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnCLassGradeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                        .addComponent(savePolicyUpdates)
                        .addComponent(classReport))
                    .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 33, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(addNewClass)
                    .addComponent(saveCurrentCLassToFile)
                    .addComponent(calculeUptoDayTotol))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pnPolicy, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 608, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(985, Short.MAX_VALUE))
        );

        tabbedPanelswith4.addTab("Class Grade", pnCLassGrade);

        rosterToolbar.setRollover(true);

        clearScreen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/clearScreen.png"))); // NOI18N
        clearScreen.setToolTipText("Clear screen");
        clearScreen.setFocusable(false);
        clearScreen.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        clearScreen.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        clearScreen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearScreenActionPerformed(evt);
            }
        });
        rosterToolbar.add(clearScreen);

        loadRosterToDB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/loadStudents.png"))); // NOI18N
        loadRosterToDB.setToolTipText("Load class roaster int database");
        loadRosterToDB.setFocusable(false);
        loadRosterToDB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        loadRosterToDB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        loadRosterToDB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadRosterToDBActionPerformed(evt);
            }
        });
        rosterToolbar.add(loadRosterToDB);

        rosterSheet.setColumns(100);
        rosterSheet.setFont(new java.awt.Font("Monaco", 1, 13)); // NOI18N
        rosterSheet.setLineWrap(true);
        rosterSheet.setRows(50);
        rosterSheet.setText("\n                 This Tab loads a class roster (or a class enrollment\n                 information) into gradebook application.\n\n                  You need to copy the enrollment of a class from CSUB\n                  webside and paste it here first. Then click 3-figuure\n                  icon to load the information or roster.\n\n                  The loading results will be listed here and a printer-\n                  friendly copy is is preferred.");
        rosterSheet.setVerifyInputWhenFocusTarget(false);
        jScrollPane6.setViewportView(rosterSheet);

        javax.swing.GroupLayout pnRosterLoaderLayout = new javax.swing.GroupLayout(pnRosterLoader);
        pnRosterLoader.setLayout(pnRosterLoaderLayout);
        pnRosterLoaderLayout.setHorizontalGroup(
            pnRosterLoaderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnRosterLoaderLayout.createSequentialGroup()
                .addGroup(pnRosterLoaderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnRosterLoaderLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jScrollPane6, javax.swing.GroupLayout.PREFERRED_SIZE, 836, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(pnRosterLoaderLayout.createSequentialGroup()
                        .addGap(346, 346, 346)
                        .addComponent(rosterToolbar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(17, Short.MAX_VALUE))
        );
        pnRosterLoaderLayout.setVerticalGroup(
            pnRosterLoaderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnRosterLoaderLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(rosterToolbar, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jScrollPane6, javax.swing.GroupLayout.PREFERRED_SIZE, 752, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 1014, Short.MAX_VALUE))
        );

        tabbedPanelswith4.addTab("Roster Loader", pnRosterLoader);

        jToolBar2.setRollover(true);

        addStudentToClass.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/addStudentToClass.png"))); // NOI18N
        addStudentToClass.setToolTipText("Add a seleceted student to class");
        addStudentToClass.setFocusable(false);
        addStudentToClass.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        addStudentToClass.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        addStudentToClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addStudentToClassActionPerformed(evt);
            }
        });
        jToolBar2.add(addStudentToClass);

        showAllGradesOfSelectedStudent.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/allGrades.png"))); // NOI18N
        showAllGradesOfSelectedStudent.setToolTipText("Show all grades of the selected student");
        showAllGradesOfSelectedStudent.setFocusable(false);
        showAllGradesOfSelectedStudent.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        showAllGradesOfSelectedStudent.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        showAllGradesOfSelectedStudent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showAllGradesOfSelectedStudentActionPerformed(evt);
            }
        });
        jToolBar2.add(showAllGradesOfSelectedStudent);

        deleteStudent.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/rm1FromClass.png"))); // NOI18N
        deleteStudent.setToolTipText("(Only at devement stage) Remove student and all classes.");
        deleteStudent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteStudentActionPerformed(evt);
            }
        });
        jToolBar2.add(deleteStudent);

        rdoAll.setText("All");
        rdoAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rdoAllActionPerformed(evt);
            }
        });
        jToolBar2.add(rdoAll);

        rdoInactive.setText("Inactive");
        rdoInactive.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rdoInactiveActionPerformed(evt);
            }
        });
        jToolBar2.add(rdoInactive);

        rdoActive.setText("Active");
        rdoActive.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rdoActiveActionPerformed(evt);
            }
        });
        jToolBar2.add(rdoActive);

        loadStudentsAndMajors.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/3persoms.png"))); // NOI18N
        loadStudentsAndMajors.setToolTipText("Load Students and Major ");
        loadStudentsAndMajors.setFocusable(false);
        loadStudentsAndMajors.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        loadStudentsAndMajors.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        loadStudentsAndMajors.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadStudentsAndMajorsActionPerformed(evt);
            }
        });
        jToolBar2.add(loadStudentsAndMajors);

        tfStudentsFilter.setColumns(15);
        tfStudentsFilter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tfStudentsFilterActionPerformed(evt);
            }
        });
        jToolBar2.add(tfStudentsFilter);

        pnMajors.setBorder(javax.swing.BorderFactory.createTitledBorder("Major List"));
        pnMajors.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N

        tblMajors.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane3.setViewportView(tblMajors);

        javax.swing.GroupLayout pnMajorsLayout = new javax.swing.GroupLayout(pnMajors);
        pnMajors.setLayout(pnMajorsLayout);
        pnMajorsLayout.setHorizontalGroup(
            pnMajorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 241, Short.MAX_VALUE)
        );
        pnMajorsLayout.setVerticalGroup(
            pnMajorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnMajorsLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 706, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pnStudents.setBorder(javax.swing.BorderFactory.createTitledBorder("Student List (All/Inactive/Active)"));
        pnStudents.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N

        tblStudents.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        scPnStudents.setViewportView(tblStudents);

        javax.swing.GroupLayout pnStudentsLayout = new javax.swing.GroupLayout(pnStudents);
        pnStudents.setLayout(pnStudentsLayout);
        pnStudentsLayout.setHorizontalGroup(
            pnStudentsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnStudentsLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(scPnStudents, javax.swing.GroupLayout.PREFERRED_SIZE, 509, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(22, Short.MAX_VALUE))
        );
        pnStudentsLayout.setVerticalGroup(
            pnStudentsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnStudentsLayout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(scPnStudents, javax.swing.GroupLayout.PREFERRED_SIZE, 713, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(17, 17, 17))
        );

        javax.swing.GroupLayout pnStudentsAndMajorsLayout = new javax.swing.GroupLayout(pnStudentsAndMajors);
        pnStudentsAndMajors.setLayout(pnStudentsAndMajorsLayout);
        pnStudentsAndMajorsLayout.setHorizontalGroup(
            pnStudentsAndMajorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnStudentsAndMajorsLayout.createSequentialGroup()
                .addGroup(pnStudentsAndMajorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnStudentsAndMajorsLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(pnMajors, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(pnStudents, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(pnStudentsAndMajorsLayout.createSequentialGroup()
                        .addGap(223, 223, 223)
                        .addComponent(jToolBar2, javax.swing.GroupLayout.PREFERRED_SIZE, 546, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(39, Short.MAX_VALUE))
        );
        pnStudentsAndMajorsLayout.setVerticalGroup(
            pnStudentsAndMajorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnStudentsAndMajorsLayout.createSequentialGroup()
                .addGap(4, 4, 4)
                .addComponent(jToolBar2, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(10, 10, 10)
                .addGroup(pnStudentsAndMajorsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(pnMajors, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(pnStudents, javax.swing.GroupLayout.PREFERRED_SIZE, 756, Short.MAX_VALUE))
                .addContainerGap(1014, Short.MAX_VALUE))
        );

        tabbedPanelswith4.addTab("Students", pnStudentsAndMajors);

        tbExportAndExport.setRollover(true);

        clearTAExportAndExport.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/clearScreen.png"))); // NOI18N
        clearTAExportAndExport.setToolTipText("Clear the creen.");
        clearTAExportAndExport.setFocusable(false);
        clearTAExportAndExport.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        clearTAExportAndExport.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        clearTAExportAndExport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearTAExportAndExportActionPerformed(evt);
            }
        });
        tbExportAndExport.add(clearTAExportAndExport);

        fileOpen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/openFile.png"))); // NOI18N
        fileOpen.setToolTipText("Open and view text file");
        fileOpen.setFocusable(false);
        fileOpen.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        fileOpen.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        fileOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileOpenActionPerformed(evt);
            }
        });
        tbExportAndExport.add(fileOpen);

        doImport.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/import2.png"))); // NOI18N
        doImport.setToolTipText("Import data from File to DB.");
        doImport.setEnabled(false);
        doImport.setFocusable(false);
        doImport.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        doImport.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        doImport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                doImportActionPerformed(evt);
            }
        });
        tbExportAndExport.add(doImport);

        doExport.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/export2.png"))); // NOI18N
        doExport.setToolTipText("Export data from DB to file.");
        doExport.setEnabled(false);
        doExport.setFocusable(false);
        doExport.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        doExport.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        doExport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                doExportActionPerformed(evt);
            }
        });
        tbExportAndExport.add(doExport);

        cbxTables.setAutoscrolls(true);
        cbxTables.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cbxTablesActionPerformed(evt);
            }
        });
        tbExportAndExport.add(cbxTables);

        loadAllTables.setIcon(new javax.swing.ImageIcon(getClass().getResource("/wang/app/gradebook/addStudentToClass.png"))); // NOI18N
        loadAllTables.setToolTipText("Load tables first.");
        loadAllTables.setFocusable(false);
        loadAllTables.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        loadAllTables.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        loadAllTables.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadAllTablesActionPerformed(evt);
            }
        });
        tbExportAndExport.add(loadAllTables);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(pBarExportAndImport, javax.swing.GroupLayout.DEFAULT_SIZE, 805, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(pBarExportAndImport, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        taExportAndImport.setColumns(20);
        taExportAndImport.setFont(new java.awt.Font("Monaco", 1, 13)); // NOI18N
        taExportAndImport.setTabSize(0);
        taExportAndImport.setText("           This Tab allows you \n                 (1) export one or all tables's to a text file. \n                 (2) import data for one or all tables from a text file.\n                 (3) open and view the contents of text file\n                The export/import result will be displayed here.\n                   \n\t\t             1. Click the button on the right of combo box first, to load tables\n             2. The contents of the text area can be clear by clicking the leftmost\n                buttom.");
        jScrollPane4.setViewportView(taExportAndImport);

        javax.swing.GroupLayout pnExportAndImportLayout = new javax.swing.GroupLayout(pnExportAndImport);
        pnExportAndImport.setLayout(pnExportAndImportLayout);
        pnExportAndImportLayout.setHorizontalGroup(
            pnExportAndImportLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnExportAndImportLayout.createSequentialGroup()
                .addGroup(pnExportAndImportLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnExportAndImportLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(pnExportAndImportLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jScrollPane4, javax.swing.GroupLayout.PREFERRED_SIZE, 831, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(pnExportAndImportLayout.createSequentialGroup()
                        .addGap(304, 304, 304)
                        .addComponent(tbExportAndExport, javax.swing.GroupLayout.PREFERRED_SIZE, 334, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(22, Short.MAX_VALUE))
        );
        pnExportAndImportLayout.setVerticalGroup(
            pnExportAndImportLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnExportAndImportLayout.createSequentialGroup()
                .addComponent(tbExportAndExport, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(11, 11, 11)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jScrollPane4, javax.swing.GroupLayout.PREFERRED_SIZE, 706, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        tabbedPanelswith4.addTab("Export/Imppot", pnExportAndImport);

        getContentPane().add(tabbedPanelswith4);
        tabbedPanelswith4.setBounds(0, 0, 880, 1872);
    }// </editor-fold>//GEN-END:initComponents

    private void savePolicyUpdatesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_savePolicyUpdatesActionPerformed
        poicyResultSetTextField.save();
        sqlClassGrade = buildGradeSQL();
        classGradeTMD.requery(sqlClassGrade);
        tbl.removeColumn(tbl.getColumnModel().getColumn(0));
        tbl.removeColumn(tbl.getColumnModel().getColumn(0));
        tbl.removeColumn(tbl.getColumnModel().getColumn(tbl.getColumnModel().getColumnCount() - 1));
    }//GEN-LAST:event_savePolicyUpdatesActionPerformed

    private void cmbSectionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbSectionsActionPerformed
        GBGlobals.section = Integer.parseInt(cmbSections.getSelectedItem().toString());
        getClassIDPolicyAndGrade();
    }//GEN-LAST:event_cmbSectionsActionPerformed

    private void cmbTermsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbTermsActionPerformed
        GBGlobals.term = cmbTerms.getSelectedItem().toString().toUpperCase();
        GBUtil.loadCourses(cmbCourses);
        getClassIDPolicyAndGrade();

    }//GEN-LAST:event_cmbTermsActionPerformed

    private void cmbYearsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbYearsActionPerformed
        GBGlobals.year = Integer.parseInt(cmbYears.getSelectedItem().toString());
        GBUtil.loadCourses(cmbCourses);
        getClassIDPolicyAndGrade();
    }//GEN-LAST:event_cmbYearsActionPerformed

    private void PCTMidterm1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PCTMidterm1ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_PCTMidterm1ActionPerformed

    private void numHWKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_numHWKActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_numHWKActionPerformed

    private void cmbCoursesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbCoursesActionPerformed
        if (cmbCourses.getItemCount() > 0) {
            GBGlobals.courseName = cmbCourses.getSelectedItem().toString();
        }
        getClassIDPolicyAndGrade();
    }//GEN-LAST:event_cmbCoursesActionPerformed

    private void calculeUptoDayTotolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_calculeUptoDayTotolActionPerformed
        boolean callResult = DBConnection.calTotal(GBGlobals.CID);
        if (callResult) {
            classGradeTMD.reload();
        }
    }//GEN-LAST:event_calculeUptoDayTotolActionPerformed

    private void saveCurrentCLassToFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveCurrentCLassToFileActionPerformed
        String fileName = GBUtil.saveClassGradeToFile(this.taExportAndImport);
        if (fileName == null) {
            JOptionPane.showMessageDialog(null, "Data is not save into to\n file " + fileName);
        } else {
            fileName = fileName.replace("/wang.app", "\n      /wang.app");
            fileName = fileName.replace("/online", "\n      /online");
            JOptionPane.showMessageDialog(null, "Data is saved to [ " + fileName
                    + " ].\n\n And the data is shown in Export/Import page.");
        }
    }//GEN-LAST:event_saveCurrentCLassToFileActionPerformed

    private void removeSelectedStudentFromClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeSelectedStudentFromClassActionPerformed
        int selectedRow = tbl.getSelectedRow();
        if (selectedRow < 0) {
            JOptionPane.showMessageDialog(this, "Select a student first, then remov.",
                    "No student is selected!", JOptionPane.WARNING_MESSAGE);
            return;
        }
        Object[] values = new Object[3];
        for (int col = 0; col < 3; col++) {
            values[col] = classGradeTMD.getValueAt(mdlRow, col + 1);
            //System.out.printf("%s\n", values[col]);
        }
        int selValue;
        selValue = JOptionPane.showConfirmDialog(null,
                String.format("Remove student <%s, %s>\nfrom class %s?",
                        values[1], values[2], GBGlobals.courseName),
                "Remove a Student",
                JOptionPane.YES_NO_OPTION,
                JOptionPane.WARNING_MESSAGE);
        if (selValue == JOptionPane.YES_OPTION) {
            DBConnection.deleteStudentFromClass((int) values[0], GBGlobals.CID);
            classGradeTMD.reload();
            GBGlobals.classSize = classGradeTMD.recordCount;
            this.setTitle(GBUtil.getClassInfo() + GBUtil.getEnrollmentInfo());
        }

        //JOptionPane.showMessageDialog(null, "Done");
    }//GEN-LAST:event_removeSelectedStudentFromClassActionPerformed

    private void rdoAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rdoAllActionPerformed
        loadStudents('%');  // All students are both active and inactive students
    }//GEN-LAST:event_rdoAllActionPerformed

    private void rdoInactiveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rdoInactiveActionPerformed
        loadStudents('N');  // The inactive students are those  graduated a few years again.
    }//GEN-LAST:event_rdoInactiveActionPerformed

    private void rdoActiveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rdoActiveActionPerformed
        loadStudents('Y');   // The ctive students are those who have not graduated. 
    }//GEN-LAST:event_rdoActiveActionPerformed

    private void addStudentToClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addStudentToClassActionPerformed
        int selectedRow = tblStudents.getSelectedRow();
        if (selectedRow < 0) {
            JOptionPane.showMessageDialog(this, "Select a student first.",
                    "No student is selected!", JOptionPane.WARNING_MESSAGE);
            return;
        }
        int localSID = Integer.parseInt(studentsTMD.getValueAt(mdlRowForStudents, 0).toString());
        int ans = JOptionPane.showConfirmDialog(this,
                // strStudent is set in table for student's event handler.
                String.format("Add student <%s>to class\n<%s> ?", GBGlobals.studentInfo, GBGlobals.classInfo),
                "Add Student to Class", JOptionPane.YES_NO_OPTION);
        if (ans == JOptionPane.NO_OPTION) {
            return;
        }
        // boolean res = DBConnection.addStudentToClass(GBGlobals.SID, GBGlobals.CID);
        boolean res = DBConnection.addStudentToClass(localSID, GBGlobals.CID);
        if (!res) {
            return;
        }
        classGradeTMD.reload();
        GBGlobals.classSize = classGradeTMD.recordCount;
        this.setTitle(GBGlobals.classInfo + GBUtil.getEnrollmentInfo());

    }//GEN-LAST:event_addStudentToClassActionPerformed

    private void addNewClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addNewClassActionPerformed

        String classFields[] = {"CRN#", "Instroctor ID", "Year", "Term", "Course Name", "Section"};
        String defValues[] = {"12345", GBGlobals.IID + "", GBGlobals.cal.get(GBGlobals.cal.YEAR) + "", cmbTerms.getSelectedItem().toString(), "CMPS 3420", "1"};
        RecordInputPane coursePane = new RecordInputPane(this, "Add Following New Class?", classFields, defValues);
        String values[] = coursePane.getRecord();
        if (values == null) {
            return;
        }
        // If new class's year doesn't exists in database, add the year into year combobox.
        if (cmbYears.getItemCount() == 0 || values[2].compareTo(cmbYears.getItemAt(0).toString()) != 0) {
            cmbYears.insertItemAt((Object) values[2], 0);
        }
        //for ( int i = 0; i < values.length; i ++ ) System.out.printf("%s\n", values[i]);
        boolean suc = DBConnection.addNewClass(values);
        //if ( suc ) this.loadAndSelectComboboxes();
    }//GEN-LAST:event_addNewClassActionPerformed

    private void removeCurrentClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeCurrentClassActionPerformed
        int ans = JOptionPane.showConfirmDialog(this, "Do you really want to remove class\n["
                + GBGlobals.classInfo + "],\nits grading policy, and enrollments?", "Remove Current Class", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        if (ans == JOptionPane.NO_OPTION) {
            return;
        }

        boolean res = DBConnection.deleteClass(GBGlobals.CID, GBGlobals.IID);
        if (!res) {
            return;
        }
        ActionListener lsnr[] = cmbCourses.getActionListeners();
        cmbCourses.removeActionListener(lsnr[0]);
        cmbCourses.removeItem(GBGlobals.courseName);
        if (cmbCourses.getItemCount() > 0) {
            cmbCourses.setSelectedIndex(0);
        } else {

            closeAndClear(); // no class available, close resultsets of class grades and policy and clear leftover data of grade and policy. 
        }
        cmbCourses.addActionListener(lsnr[0]);
    }//GEN-LAST:event_removeCurrentClassActionPerformed

    private void showAllGradesOfSelectedStudentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showAllGradesOfSelectedStudentActionPerformed
        int selectedRow = tblStudents.getSelectedRow();
        if (selectedRow < 0) {
            JOptionPane.showMessageDialog(this, "Select a student first.",
                    "No student is selected!", JOptionPane.WARNING_MESSAGE);
            return;
        }
        int localSID = Integer.parseInt(studentsTMD.getValueAt(mdlRowForStudents, 0).toString());
        String nameGrades = DBConnection.getAllGrades(localSID);
        //nameGrades = nameGrades.replace("\t", "\u0009");
        if (nameGrades == null || nameGrades.trim().length() < 1) {
            return;
        }
        JOptionPane.showMessageDialog(this, new JTextArea(nameGrades), "Student Grades", JOptionPane.WARNING_MESSAGE);
    }//GEN-LAST:event_showAllGradesOfSelectedStudentActionPerformed

    private void clearScreenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearScreenActionPerformed
        this.rosterSheet.setText("");
    }//GEN-LAST:event_clearScreenActionPerformed

    private void loadRosterToDBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadRosterToDBActionPerformed
        // The user should copy a class roaster(use frinedly print version) from CSUB webside.
        // paste the copy to a text area. The clik the load roster butten.
        // For more details
        if (rosterSheet.getLineCount() < 15) {
            JOptionPane.showMessageDialog(this, "Copy & paste CSUB's class roster here first!",
                    "No Data to Load", JOptionPane.WARNING_MESSAGE);
            return;
        }
        RosterLoader.process(this.rosterSheet);
        if (GBGlobals.CID != RosterLoader.courseID) {
            return;
        }

        classGradeTMD.reload();
        GBGlobals.classSize = classGradeTMD.recordCount;
        this.setTitle(GBGlobals.classInfo + GBUtil.getEnrollmentInfo());
    }//GEN-LAST:event_loadRosterToDBActionPerformed

    private void removeRosterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeRosterActionPerformed
        if (GBGlobals.CID <= 0) {
            return;
        }
        int ans = JOptionPane.showConfirmDialog(this, "Do want to remove all students in\nGBGlobals.courseInfo?",
                "Remove Class Roster?", JOptionPane.YES_OPTION);
        if (ans == JOptionPane.NO_OPTION) {
            return;
        }

        boolean ok = DBConnection.removeClassRoster(GBGlobals.CID);
        if (!ok) {
            return;
        }

        classGradeTMD.reload();
        GBGlobals.classSize = classGradeTMD.recordCount;
        this.setTitle(GBGlobals.classInfo + GBUtil.getEnrollmentInfo());
    }//GEN-LAST:event_removeRosterActionPerformed

    private void tfStudentsFilterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tfStudentsFilterActionPerformed

    }//GEN-LAST:event_tfStudentsFilterActionPerformed

    private void deleteStudentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteStudentActionPerformed
        int selectedRow = tblStudents.getSelectedRow();
        if (selectedRow < 0) {
            JOptionPane.showMessageDialog(this, "Select a student first.",
                    "No student is selected!", JOptionPane.WARNING_MESSAGE);
            return;
        }
        int localSID = Integer.parseInt(studentsTMD.getValueAt(mdlRowForStudents, 0).toString());
        int ans = JOptionPane.showConfirmDialog(this,
                // strStudent is set in table for student's event handler.
                String.format("Delete student <%s> \nand all courses taken?\n", GBGlobals.studentInfo),
                "Delete Student", JOptionPane.YES_NO_OPTION);
        if (ans == JOptionPane.NO_OPTION) {
            return;
        }
        // boolean res = DBConnection.addStudentToClass(GBGlobals.SID, GBGlobals.CID);
        boolean res = DBConnection.deleteStudent(localSID, GBGlobals.IID);
        if (!res) {
            return;
        }
        loadStudents();
    }//GEN-LAST:event_deleteStudentActionPerformed

    private void classReportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_classReportActionPerformed
        if (GBGlobals.CID < 1) {
            return;
        }
        // After the report is designed,  the following steps are used to
        // display a report:
        //      1. compile the report,
        //      2. put parameters to a hash map.
        //      3. fill report with compiled report object, parameter-map and
        //              data source.
        //      4. display the report.
        

        /*
        Context context = InitialContext();
        String reportsDirPath = context.getRealPath("/reports/");
       
        if (!reportsDirPath.exists()) {
            throw new FileNotFoundException(String.valueOf(reportsDir));
        }
        
        parameters.put(JRParameter.REPORT_FILE_RESOLVER, new SimpleFileResolver(reportsDir));
            
        <imageExpression class="java.lang.String"><![CDATA["images/logo.jpg"]]></imageExpression>
        <subreportExpression class="java.lang.String"><![CDATA["mysubreport.jasper"]]></subreportExpression>
        
        */
        try {
            String reportFilePath = "/Users/hwang/NetBeansProjects/wang.app.gradebook/dist/reports/";
            // JasperReport ra = JasperCompileManager.compileReport(sourceFilePath + "classGradeReport.jrxml");
            //File file = new File("classGradeReport.jrxml");
            //String reportFilePath = file.getAbsolutePath();
            System.out.printf("Absolutepath of jasper report file = %s\n", reportFilePath );
            //if ( true ) return;
            JasperReport ra = JasperCompileManager.compileReport(reportFilePath + "classGradeReport.jrxml" );

            
            if (parametersMap == null) {
                parametersMap = new HashMap();
            } else {
                parametersMap.clear();
            }
            parametersMap.put("classID", GBGlobals.CID);
            parametersMap.put("subTitle", GBGlobals.classInfo + GBGlobals.enrollmentInfo);
            JasperPrint rb = JasperFillManager.fillReport(ra, parametersMap, DBConnection.cnn);
            JasperViewer.viewReport(rb, false);
        } catch (JRException ex) {
            ex.printStackTrace();
        }
    }//GEN-LAST:event_classReportActionPerformed

    private void loadStudentsAndMajorsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadStudentsAndMajorsActionPerformed

        this.loadMajors();
        this.loadStudents();
        this.addStudentToClass.setEnabled(true);
        this.showAllGradesOfSelectedStudent.setEnabled(true);
    }//GEN-LAST:event_loadStudentsAndMajorsActionPerformed

    private void loadAllTablesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadAllTablesActionPerformed
        Vector<String> vAllTableNames = DBConnection.getAllTableNames();
        vAllTableNames.add(0, "All Tables");
        cbxTables.setModel(new DefaultComboBoxModel<String>(vAllTableNames));
        cbxTables.setSelectedIndex(0);
        this.loadAllTables.setEnabled(false);
        doExport.setEnabled(true);
        doImport.setEnabled(true);
    }//GEN-LAST:event_loadAllTablesActionPerformed

    private void fileOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileOpenActionPerformed
        String filePath = GBUtil.getFileName(GBGlobals.gradebookData);
        GBUtil.printFileOnTextArea(filePath, taExportAndImport);
    }//GEN-LAST:event_fileOpenActionPerformed

    private void doExportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_doExportActionPerformed
        String fileName = cbxTables.getSelectedItem() + "-" + DBConnection.dbUser + '-' + DBConnection.hostName
                + "-" + (new SimpleDateFormat("yyyyMMdd").format(GBGlobals.cal.getTime()) + ".dat");
        fileName.replaceAll(" ", "");
        String message = "Data of [" + cbxTables.getSelectedItem() + "] will be backed up to FILE."
                + "\nYou can use or change the suggested file name:";

        fileName = JOptionPane.showInputDialog(null, message, fileName);

        if (fileName == null) {
            return;
        }

        int totalNumberOfRecords = DBConnection.getRecordCountsOfAllTables(); // all number of records of all table in grade book.

        fileName = GBGlobals.gradebookData + "backupData/" + fileName;
        ExportImport.doExport(fileName, cbxTables, taExportAndImport, pBarExportAndImport, totalNumberOfRecords);
    }//GEN-LAST:event_doExportActionPerformed

    private void doImportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_doImportActionPerformed

        String fileName = GBUtil.getFileName(GBGlobals.gradebookData + "backupData/");
        if (fileName == null) {
            return;
        }
        System.out.printf("FileName = %s\n", fileName);
        int ans = JOptionPane.showConfirmDialog(this, "Do you want the data in ["
                + fileName.substring(fileName.lastIndexOf("/") + 1)
                + "]\n be loaded into [" + cbxTables.getSelectedItem()
                + "] of " + DBConnection.dbUser + "?",
                "File --> Database", JOptionPane.OK_CANCEL_OPTION);

        if (ans != JOptionPane.OK_OPTION) {
            return;
        }

        ExportImport.doImport(fileName, cbxTables, taExportAndImport, pBarExportAndImport);

    }//GEN-LAST:event_doImportActionPerformed

    private void cbxTablesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbxTablesActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_cbxTablesActionPerformed

    private void clearTAExportAndExportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearTAExportAndExportActionPerformed
        taExportAndImport.setText("");
    }//GEN-LAST:event_clearTAExportAndExportActionPerformed

    void closeAndClear() {
        tbl.setVisible(false);
        if (classGradeTMD != null) {
            classGradeTMD.clear();
        }
        if (poicyResultSetTextField != null) {
            poicyResultSetTextField.clear();
        }
        setTitle("No class is Selected.");
        this.comments.setText("");
    }

    void createAndSetNewFilter(String regExp) {
        RowFilter<SimpleRSModel, Object> fltr = null;
        try {
            fltr = RowFilter.regexFilter(regExp, 1, 2);
        } catch (java.util.regex.PatternSyntaxException e) {
            e.printStackTrace();
            return;
        }
        studentsSorter.setRowFilter(fltr);
    }
    // Get CID and Load class data.

    void getClassIDPolicyAndGrade() {

        GBGlobals.CID = -1;
        if (!areCourseInfoSelected()) {
            closeAndClear();
            return;
        }
        tbl.setVisible(true);
        oldCID = GBGlobals.CID;
        GBGlobals.CID = DBConnection.getCourseID();
        if (GBGlobals.CID > 0 && GBGlobals.CID != oldCID) {
            loadClassGrade();
            this.setTitle(GBUtil.getClassInfo() + GBUtil.getEnrollmentInfo());
        }
    }

    void addRadionButtonToGroup() {
        bnGrpForRadion.add(rdoAll);
        bnGrpForRadion.add(rdoInactive);
        bnGrpForRadion.add(rdoActive);
        rdoActive.setSelected(true);
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(GradebookJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(GradebookJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(GradebookJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(GradebookJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new GradebookJFrame().setVisible(true);
            }
        });
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    javax.swing.JTextField HWKDrops;
    javax.swing.JTextField PCTFinal;
    javax.swing.JTextField PCTMidterm1;
    javax.swing.JTextField PCTMidterm2;
    javax.swing.JButton addNewClass;
    javax.swing.JButton addStudentToClass;
    javax.swing.ButtonGroup bnGrpForRadion;
    javax.swing.JButton calculeUptoDayTotol;
    javax.swing.JComboBox cbxTables;
    javax.swing.JButton classReport;
    javax.swing.JButton clearScreen;
    javax.swing.JButton clearTAExportAndExport;
    javax.swing.JComboBox cmbCourses;
    javax.swing.JComboBox cmbSections;
    javax.swing.JComboBox cmbTerms;
    javax.swing.JComboBox cmbYears;
    javax.swing.JTextArea comments;
    javax.swing.JButton deleteStudent;
    javax.swing.JButton doExport;
    javax.swing.JButton doImport;
    javax.swing.JComboBox editableItems;
    javax.swing.JButton fileOpen;
    javax.swing.JLabel jLabel1;
    javax.swing.JLabel jLabel10;
    javax.swing.JLabel jLabel13;
    javax.swing.JLabel jLabel2;
    javax.swing.JLabel jLabel3;
    javax.swing.JLabel jLabel4;
    javax.swing.JLabel jLabel5;
    javax.swing.JLabel jLabel6;
    javax.swing.JLabel jLabel7;
    javax.swing.JLabel jLabel8;
    javax.swing.JLabel jLabel9;
    javax.swing.JPanel jPanel1;
    javax.swing.JPanel jPanel3;
    javax.swing.JScrollPane jScrollPane1;
    javax.swing.JScrollPane jScrollPane2;
    javax.swing.JScrollPane jScrollPane3;
    javax.swing.JScrollPane jScrollPane4;
    javax.swing.JScrollPane jScrollPane6;
    javax.swing.JTextField jTextField1;
    javax.swing.JToolBar jToolBar1;
    javax.swing.JToolBar jToolBar2;
    javax.swing.JButton loadAllTables;
    javax.swing.JButton loadRosterToDB;
    javax.swing.JButton loadStudentsAndMajors;
    javax.swing.JTextField maxFinal;
    javax.swing.JTextField maxHWK;
    javax.swing.JTextField maxMidterm1;
    javax.swing.JTextField maxMidterm2;
    javax.swing.JTextField numHWK;
    javax.swing.JProgressBar pBarExportAndImport;
    javax.swing.JTextField pctHWK;
    javax.swing.JPanel pnCLassGrade;
    javax.swing.JPanel pnExportAndImport;
    javax.swing.JPanel pnMajors;
    javax.swing.JPanel pnPolicy;
    javax.swing.JPanel pnRosterLoader;
    javax.swing.JPanel pnStudents;
    javax.swing.JPanel pnStudentsAndMajors;
    javax.swing.JRadioButton rdoActive;
    javax.swing.JRadioButton rdoAll;
    javax.swing.JRadioButton rdoInactive;
    javax.swing.JButton removeCurrentClass;
    javax.swing.JButton removeRoster;
    javax.swing.JButton removeSelectedStudentFromClass;
    javax.swing.JTextArea rosterSheet;
    javax.swing.JToolBar rosterToolbar;
    javax.swing.JButton saveCurrentCLassToFile;
    javax.swing.JButton savePolicyUpdates;
    javax.swing.JScrollPane scPnStudents;
    javax.swing.JButton showAllGradesOfSelectedStudent;
    javax.swing.JTextArea taExportAndImport;
    javax.swing.JTabbedPane tabbedPanelswith4;
    javax.swing.JToolBar tbExportAndExport;
    javax.swing.JTable tbl;
    javax.swing.JTable tblMajors;
    javax.swing.JTable tblStudents;
    javax.swing.JTextField tfStudentsFilter;
    // End of variables declaration//GEN-END:variables

    // Variables dfined by H. Wang
    Connection cnn = null;
    JTextField tfPolicy[] = null; //new JTextField[] { numHWK, maxHWK, pctHWK, HWKDrops,maxMidterm1, PCTMidterm1, maxMidterm2, PCTMidterm2, maxFinal, PCTFinal} ;
    ResultSetTextFields poicyResultSetTextField = null;

    String sqlPolicy = "SELECT NUMHWK, MaxHWK, PCTHWK, HWKDrops, MaxMidterm1, PCTMidterm1, MaxMidterm2, PCTMidterm2, MaxFinal, PCTFinal FROM Policy  WHERE CID = ";
    String sqlClassGrade = null;   // It is dynamic due the number of assignments changeds.
    String sqlStudents = "SELECT SID \"Student ID\", LASTNAME \"Last Name\", FIRSTNAME \"First Name\", ACTIVE, OSUSERNAME \"User Nane\", MAJORCODE, MAJOR \"Major Decl.\" FROM vStudents WHERE Active like ";
    String sqlMajors = "SELECT Code \"Major Code\", Major \"Major Name\", ShortName Short FROM Majors ";
    ResultSetTableModel classGradeTMD = null;
    SimpleRSModel studentsTMD = null;
    TableRowSorter studentsSorter = null;
    // Document            docstudentsFilter = null;
    SimpleRSModel majorsTMD = null;

    // JTable tbl = null;  // JTable is defined by NetBeans IDE
    TableRowSorter<ResultSetTableModel> sorter = null;
    int tableRow, mdlRow, mdlRowForMajors, mdlRowForStudents;
    Color commentsChangedColor = Color.BLUE;
    int oldCID = -1;
    public HashMap parametersMap = null;
    TitledBorder title = null;
}
