package wang.app.gradebook;

import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JTextField;
import java.awt.Component;
import javax.swing.JComponent;
import java.awt.GridLayout;
import javax.swing.InputVerifier;
import javax.swing.SwingConstants;


class PasswordPane {
    Component parent = null;
    JPanel pane = new JPanel();
    JPasswordField passwd = new JPasswordField(10);

    public PasswordPane ( Component parent ) {
        this.parent = parent;
        pane.add( passwd  );
    }

    String  getPassword() {
        String options[] = {"OK", "Cancel" };
        int choice = JOptionPane.showOptionDialog(parent, pane, "Enter Password Please",
        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE, null, options, null);
        if ( choice != JOptionPane.YES_OPTION ) return null;
        return new String (passwd.getPassword());
   };
}
public class RecordInputPane {
    
         class DigitsOnlyVerifier extends InputVerifier {
         public boolean verify(JComponent input) {
             JTextField tf = (JTextField) input;
             return tf.getText().matches("[0-9]+");
         }
     }

    static final int hGap = 5, vGap = 1;
    Component parent = null;
    String    title = null;

    JPanel pane = new JPanel();
    JTextField txts[] = null;
    String values[] = null;   
    DigitsOnlyVerifier dVerifier = new DigitsOnlyVerifier();
   
    public RecordInputPane ( Component parent,  String title, String recFieldNames[] ) {
	String defValues [] = new String[recFieldNames.length];
	for ( int i = 0; i < recFieldNames.length; i ++ ) defValues[i] = "";
	setup( parent, title, recFieldNames, defValues);
    }

    public RecordInputPane ( Component parent,  String title, String recFieldNames[], String []  defValues )
    {  setup( parent, title, recFieldNames, defValues);  }

    void setup ( Component parent,  String title, String recFieldNames[],  String defValues[] ) {
	this.parent = parent;
	this.title = title;

	txts = new JTextField[recFieldNames.length];
	values = new String[recFieldNames.length];

	pane.setLayout( new GridLayout( recFieldNames.length, 2, hGap, vGap) );

	for ( int i = 0; i < recFieldNames.length; i ++ ) {
		pane.add( new JLabel ( recFieldNames[i], SwingConstants.RIGHT ) );
		txts[i] = new JTextField(defValues[i], 10);
                if ( i >= 0 && i <= 2 || i == 5 ) txts[i].setInputVerifier(dVerifier);  // For those fied with numerical value, add value verifier.
		pane.add( txts[i] );
	
	}

    }

    String [] getRecord() {

	String options[] = {"Add", "Cancel" };

	int choice = JOptionPane.showOptionDialog(parent, pane, title, JOptionPane.YES_NO_OPTION,
			JOptionPane.PLAIN_MESSAGE, null, options, null);

	if ( choice != JOptionPane.YES_OPTION ) return null;

	for ( int i = 0; i < txts.length; i ++ ) values[i] = txts[i].getText();

	return values;
   };
}

