package wang.app.gradebook;

import java.io.*;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

/** March 31, 2016
 * The class roster data form have be changed from one line per student to multiple line
 * per student.
 *   The old data format:
 ----------------------------------------------------------------------------------	
 ID         Name              Units Program and Plan	 Academic Level 
 1     900417720  Armstrong,Amber Jo  0.00  UGRD - Baccalaureate - 
 Computer Science  Junior  
 ----------------------------------------------------------------------------------

 The new data format: And the class load program has to be updated based on the new format.
 -------------------------------------------------------------------------------------
 Enrolled Students
 ID	Name	Units	Program and Plan	Academic Level	Status Note	Add Dt	Grade Dt
 Row 1	
 000561483
 Buenaventura,John Henry Navarro
 5.00
 UGRD - Baccalaureate - 
 Computer Science - BS - 
 Information Systems
 Senior

 10/27/2015
 03/22/2016
 -------------------------------------------------------------------------------------
 */    

class RosterLoader {
    static final String [] majors = {
	"Computer Science", "Computer Engineering", "Mathematics", "Pre-Engineering", "Physics", "Geology",
	"Anthropology", "Biology", "Chemistry", "Natural Sciences", "Nursing",
	"Art", "Communications", "English", "History", "Modern Languages",
	"Music", "Philosophy", "Theatre", "Religious Studies", "Literatures",
	"Accounting", "Business Administration", "Economics",
	"Environmental Resource Mgmt.",	"Management & Marketing", "Management Information Systems",
	"Public Policy Administration", "Finance", "Advanced Educational Studies", "Criminal Justice", "Liberal Studies",
	"Physical Education", "Political Science", "Psychology", "Social Work", "Sociology",
	"Special Education", "Teacher Education", "Kinesiology", "Seeking Credential", "Special Major",
	"PBAC", "Undeclared" 
    };

    static final int [] majorCode = {
	1, 11, 2, 3, 4, 5, 6, 7, 8, 9, 10,
	31, 32, 33, 34, 35, 36, 37, 38,39, 40,
	50, 51, 52, 53, 54, 55, 56, 57,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
	90, 91, 92,
	-1
    };

    static int 		noOfLines, noOfChars, // lines and characters processed.
                        noOfStusOnSheet,
                        noOfStusAdded, noOfStusFailedAdd,    // nmbers of students who have be added or failed to added to Students table
                        noOfStusEnrolled, noOfStusFailedEnroll, // numbers of students who have been enrolled and failed to enroll.
	dataLength, // total number of characters in class roster.

                  courseID;  // class CRN for the data to be loaded.
    static String       courseTitle;
    static Pattern	pattern = null;
    static Matcher	matcher = null;
    static String	rosterData, // The string contains the entire clas roster.
			studentInfo[] = new String[6], // strings of students' 6 field.
			line ;          // holds one line of data.
    static StringBuffer  resBuf = new StringBuffer();
    static LineNumberReader    lineReader = null; 
    static boolean	majorFound = false;
    static JTextArea           rosterSheet = null;

    static boolean checkFoRreadiness() {
            //   Step1:   Test if the roster is copied. If not return.
        if ( rosterSheet.getText().trim().length() < 50) {
            JOptionPane.showMessageDialog(null, "Copy CSUB class roster of printer-friendly version\n" +
                                                 "and paste in following text box first.");
            return false;
        } // A roster shoud gave at lest 1 studen. A student should have aournd 75 chars.

       // Step 2: Ask for a course ID
       String strLocalSID = null;
        do {
            strLocalSID = JOptionPane.showInputDialog("Enter Class CRN Number", GBGlobals.CID);
            if ( strLocalSID == null ) return false ; // If InputDialog is Cancelled, null is return.
        } while (! strLocalSID.matches( "^[0-9]+$"));
     
        courseID = Integer.parseInt(strLocalSID);
       // Verify whether the given course title is in Data
       courseTitle = DBConnection.getCourseTitle(courseID);
       if ( courseTitle == null ) {
           JOptionPane.showMessageDialog(null, "Makd sure Class " + strLocalSID + " is created first.", 
                   "No Such CLass in DB", JOptionPane.ERROR_MESSAGE);
           return false;
       }
             // System.out.printf("Class roster will be added to class, %s\n", courseTitle);        

       return true;
    }
    static int getMajorCode( String line ) {
	int idx ;
	for ( int i = 0; i < majors.length; i ++ ) {
	    idx = line.indexOf( majors[i] ) ;
	    if ( idx >= 0 ) return majorCode[i];
	}
	return -100;
    }

    public static void process( JTextArea taSheet ) {
        rosterSheet = taSheet;
	rosterData = rosterSheet.getText().replaceAll("\t", " " );
	dataLength = rosterData.length();
	resBuf.delete (0, resBuf.length() );
        boolean ready = checkFoRreadiness();
        rosterSheet.setText("");
        if ( !ready ) return;
	try { 
	    setLineReader (); 
	    noOfLines =  noOfChars = noOfStusOnSheet = 0;
            noOfStusAdded  = noOfStusFailedAdd = 0;
            noOfStusEnrolled = noOfStusFailedEnroll = 0;
            
	    while ( (line = lineReader.readLine() )!= null ) {
		noOfLines++;
		noOfChars += line.length() + 1; // end of line is throwed away bu readline.
		line = line.trim();
		if ( line == null || line.length() < 1 ) continue;

		// A line for student seeking for 2nd degree that contain prevsious 
		// degree name.
		if ( line.indexOf(" - 2nd ") >= 0 ) continue;

		// The line contains record number.
		if ( line.matches("Row \\d+" )) {
		    noOfStusOnSheet ++; continue;
		}

		if ( nextID( line ) > 0 ) continue;
		if ( nextName( line ) > 0 ) continue;
		if ( nextMajor(line ) > 0 ) {  // final part of a student info is obtained.
		   resBuf.append( String.format("\n   Row %3d: ", + noOfStusOnSheet ));
                   resBuf.append (String.format("%10s %15s %25s %2s %15s %3s ", 
                            studentInfo[0],studentInfo[1],studentInfo[2],studentInfo[3],studentInfo[4],studentInfo[5] ));
                    rosterSheet.append(resBuf.toString());
                    resBuf.delete(0, resBuf.length());
                    // for ( int i = 0; i < 6; i ++ ) { resBuf.append(studentInfo[i]).append('-');}
                    boolean res = addStudentToClass();
                    if ( res ) noOfStusAdded ++;
                    else       noOfStusFailedAdd ++;
                    
                    res = enrollStudent();
                    if ( res ) noOfStusEnrolled ++;
                    else noOfStusFailedEnroll ++;
		}
	    }
            rosterSheet.append( getProcessData() );
	} catch (Exception e) { System.out.printf("Error in next student field");
	    e.printStackTrace(); 
        }
    }

    static void setLineReader () {
	try {
	    lineReader = new LineNumberReader ( new StringReader( rosterData )) ;
	} catch ( Exception e) {  }

    }
    static int nextID ( String line ) {
	pattern = Pattern.compile("[0-9]{9}" );
	matcher = pattern.matcher(line);
	if ( matcher.find( ) ) {
	    studentInfo[0] = line.substring( matcher.start()); // save ID 
	    majorFound = false; // there are multiple line contains major information
	    // major found to prevent a student will be inserted twice.
	    return 1;
	}
	return -1;
    }
    static int nextName( String line ) {
	pattern = Pattern.compile("[A-Z][A-Za-z ]+,");
	matcher = pattern.matcher(line);
	if ( matcher.find( ) ) {
	    studentInfo[1] = line.substring( matcher.start(), matcher.end() - 1) ; // student's last name
	    studentInfo[2] = line.substring(matcher.end()); // student's first mame
	    studentInfo[3] =  "Y";	    // active or not. csub letter id.
	    studentInfo[4] = Character.toLowerCase(studentInfo[2].charAt(0) ) + studentInfo[1].toLowerCase().replace(" ", "");
            if ( studentInfo[4].length() > 15 ) studentInfo[4] = studentInfo[4].substring(0, 14);
	    return 2;
	}
	return -1;
    }
    static int nextMajor(String line) {
	if ( majorFound ) return -1;
	int code = getMajorCode( line ) ;
	if ( getMajorCode( line ) >= -1 ) {
	    studentInfo[5] = "" + code;
	    majorFound = true;
	    return 3;
	}
	else return -1;
    }
    static boolean addStudentToClass() {
        boolean ok = DBConnection.addNewStudent(studentInfo);
        //System.out.printf("%s is added %s\n", studentInfo.toString(), ok ? " successfully." : "unsuccessfully." );
        return ok;
    }
    static boolean enrollStudent() {
        return DBConnection.addStudentToClass(Integer.parseInt(studentInfo[0]), courseID);
    }
    public RosterLoader() {
    }
    public static String getProcessData() {
	return resBuf.toString() +
            String.format("\n\n   [%s] Roster: %d-lines, %d-chars %d-Students\n",
                            courseTitle, noOfLines, noOfChars, noOfStusOnSheet ) +
	    String.format ("\n           Students Added to DB:     %d Failed     %5d Added\n",
			      noOfStusFailedAdd, noOfStusAdded) +
	    String.format ("\n     Students Enrolled to Class:     %d Failed     %5d Enrolled\n",
			      noOfStusFailedEnroll, noOfStusEnrolled);
    }
}
